require( "scripts/style.lua" );

HeaderFont = {
  bigButtonFont,
  50,
  DarkRedColor
};

local yes="yes" ;
local yesname="yes" ;
local no="no" ;	
local noname="no" ;	
local name="yesnobox";
	
if (gDialogTable.yeslabel) then
	yes = gDialogTable.yeslabel ;
end
if (gDialogTable.nolabel) then
	no = gDialogTable.nolabel ;
end
if (gDialogTable.yesname) then
	yesname = gDialogTable.yesname;
end
if (gDialogTable.noname) then
	noname = gDialogTable.noname;
end

if (gDialogTable.name) then
	name = gDialogTable.name;
end

if PauseGame then PauseGame(); end;


MakeDialog
{
	name=name, -- Remember, this is like saying table['name']=name, so it works.
    Bitmap
    {
        name="grayimage",
        image="backgrounds/shadow.png",
        alpha=true,
        x=0,
        y=0
    };
    Bitmap
    {
		image="backgrounds/submit_hs",
		x=kCenter,
		y=kCenter,

		SetStyle(DialogTitleText),
        Text
        {
            font = HeaderFont,
            name = "yesnotitle",
            x=0,y=5,w=kMax,h=kMax,
            flags = kHAlignCenter + kVAlignTop,
            label = gDialogTable.title,
        };
		SetStyle(DialogBodyText),
		Text
		{
			name = "yesnobody",
            font = { standardFont, 28, BlackColor };
			x=125,y=46,
			w=kMax-135,h=kMax-70,
			flags = kVAlignCenter + kHAlignCenter,
			label= gDialogTable.body,
		};
    };
    SetStyle(ButtonStyle),
    Button
    {
        command=
            function()
                if (gDialogTable.yes) then 
                    gDialogTable.yes() ; 
                end
				if( ResumeGame) then ResumeGame(); end;
            end;
        close = true,
        flags = 5,
        label = yes,
        name = yesname,
        x=250, y=404,
        graphics = StButtonGraphicsSm,
        font = BlackButtonFont;
    };
    Button
    {
        command=
            function() 
                if (gDialogTable.no) then
                    gDialogTable.no() ; 
                end
				if( ResumeGame) then ResumeGame(); end;
            end;
        close = true,
        flags = 5,
        label = no,
        name = noname,
        x=412, y=404, --kMax-50,
        graphics = StButtonGraphicsSm,
        font = BlackButtonFont;
    };

} -- MakeDialog

SetImageAlpha("grayimage",0.4);
